//Caption: Program to find the spectral information of discrete time  signal
//Calculation of DFT and IDFT
//Plotting Magnitude and Phase Spectrum
clc;
close;
clear;
xn = input('Enter the real input discrete sequence x[n]=');
N = length(xn);
XK = zeros(1,N);
IXK = zeros(1,N);
//Code block to find the DFT of the Sequence
for K = 0:N-1
    for n = 0:N-1
        XK(K+1) = XK(K+1)+xn(n+1)*exp(-%i*2*%pi*K*n/N);
    end
end
[phase,db] = phasemag(XK)
disp(XK,'Discrete Fourier Transform X(k)=')
disp(abs(XK),'Magnitude Spectral Samples=')
disp(phase,'Phase Spectral Samples=')
n = 0:N-1;
K = 0:N-1;
figure(1)
subplot(2,2,1)
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,xn)
xlabel('Time Index n---->')
ylabel('Amplitude xn---->')
title('Discrete Input Sequence')
subplot(2,2,2)
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',K,abs(XK))
xlabel('Frequency Sample Index K---->')
ylabel('|X(K)|---->')
title('Magnitude Spectrum')
subplot(2,2,3)
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',K,phase)
xlabel('Frequency Sample Index K---->')
ylabel('<X(K) in radians---->')
title('Phase Spectrum')
//Code block to find the IDFT of the sequence
for n = 0:N-1
    for K = 0:N-1
        IXK(n+1) = IXK(n+1)+XK(K+1)*exp(%i*2*%pi*K*n/N);
    end
end
IXK = IXK/N;
ixn = real(IXK);
subplot(2,2,4)
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',[0:N-1],ixn)
xlabel('Discrete Time Index n ---->')
ylabel('Amplitude x[n]---->')
title('IDFT sequence')
//Example
//
//Enter the real input discrete sequence x[n]=[1,2,3,4]
// 
// Discrete Fourier Transform X(k)=   
// 
//    10.  - 2. + 2.i  - 2. - 9.797D-16i  - 2. - 2.i  
// 
// Magnitude Spectral Samples=   
// 
//    10.    2.8284271    2.    2.8284271  
// 
// Phase Spectral Samples=   
// 
//    0.    135.    180.    225.  
// 